/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.passthroughsigns.util;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ConfigurationHandler {
    static Configuration config;
    static boolean shouldWallSignBePassable;
    static boolean shouldBannerBePassable;
    static boolean shouldItemFrameBePassable;
    static boolean shouldPaintingsBePassable;
    static boolean turnOffItemRotation;
    static boolean shiftClickQuark;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        shouldWallSignBePassable = config.getBoolean("Ignore wall signs", "general", true, "Whether to ignore wall signs when attached to an interactable block or not.");
        shouldBannerBePassable = config.getBoolean("Ignore banners", "general", false, "Whether to ignore banners when attached to an interactable block or not. ");
        shouldItemFrameBePassable = config.getBoolean("Ignore item frames", "general", false, "Whether to ignore item frames when attached to an interactable block or not");
        turnOffItemRotation = config.getBoolean("Turn off item rotation", "general", false, "Disable default behaviour of item frames rotation display, when not sneaking (Recommended when ignoring item frames is enabled)");
        shouldPaintingsBePassable = config.getBoolean("Ignore paintings", "general", false, "Whether to ignore paintings when attached to an interactable block or not.");
        shiftClickQuark = config.getBoolean("Shift-click to ignore signs (Quark)", "general", true, "Whether shift-click is required to ignore signs, when Quark is installed.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("passthroughsigns")) {
            ConfigurationHandler.loadConfiguration();
        }
    }
}

