/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge;

import customskinloader.forge.ForgeTweaker;
import customskinloader.forge.platform.IFMLPlatform;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class TransformerManager {
    public static boolean isDevelopmentEnvironment = false;
    public static boolean useDeobfName = false;
    private static final Remapper remapper = IFMLPlatform.FMLPlatformInitializer.getPlatform().getRemapper();
    public Map<String, IClassTransformer> classMap = new HashMap<String, IClassTransformer>();
    public Map<String, Map<Supplier<String>, IMethodTransformer>> srgMap = new HashMap<String, Map<Supplier<String>, IMethodTransformer>>();
    public Map<String, Map<String, IMethodTransformer>> map = new HashMap<String, Map<String, IMethodTransformer>>();

    public static String mapClassName(String name) {
        return remapper.mapType(name);
    }

    public static String mapFieldName(String owner, String name, String desc) {
        return remapper.mapFieldName(owner, name, desc);
    }

    public static String mapMethodName(String owner, String name, String desc) {
        return remapper.mapMethodName(owner, name, desc);
    }

    public static String mapMethodDesc(String desc) {
        return remapper.mapMethodDesc(desc);
    }

    public static boolean checkClassName(String name, String deobfName) {
        if (isDevelopmentEnvironment) {
            return name.equals(deobfName);
        }
        return TransformerManager.mapClassName(name).equals(deobfName);
    }

    public static boolean checkMethodName(String owner, String name, String desc, String srgName) {
        if (isDevelopmentEnvironment) {
            return TransformerManager.mapMethodName(owner, srgName, desc).equals(name);
        }
        return TransformerManager.mapMethodName(owner, name, desc).equals(srgName);
    }

    public static boolean checkMethodDesc(String desc, String deobfDesc) {
        if (isDevelopmentEnvironment) {
            return desc.equals(deobfDesc);
        }
        return TransformerManager.mapMethodDesc(desc).equals(deobfDesc);
    }

    public TransformerManager(IClassTransformer[] classTransformers, IMethodTransformer[] methodTransformers) {
        TransformTarget tt;
        for (IClassTransformer iClassTransformer : classTransformers) {
            tt = this.getTransformTarget(iClassTransformer.getClass());
            if (tt == null) continue;
            this.addClassTransformer(tt.className(), iClassTransformer);
        }
        for (IMethodTransformer iMethodTransformer : methodTransformers) {
            tt = this.getTransformTarget(iMethodTransformer.getClass());
            if (tt == null) continue;
            this.addMethodTransformer(tt, tt.className(), iMethodTransformer);
        }
    }

    private TransformTarget getTransformTarget(Class<?> cl) {
        ForgeTweaker.logger.info("[CSL DEBUG] REGISTERING TRANSFORMER %s", cl.getName());
        if (!cl.isAnnotationPresent(TransformTarget.class)) {
            ForgeTweaker.logger.info("[CSL DEBUG] ERROR occurs while parsing Annotation");
            return null;
        }
        return cl.getAnnotation(TransformTarget.class);
    }

    private void addClassTransformer(String className, IClassTransformer transformer) {
        if (!this.classMap.containsKey(className)) {
            this.classMap.put(className, transformer);
            ForgeTweaker.logger.info("[CSL DEBUG] REGISTERING CLASS %s", className);
        }
    }

    private void addMethodTransformer(TransformTarget target, String className, IMethodTransformer transformer) {
        if (!this.srgMap.containsKey(className)) {
            this.srgMap.put(className, new HashMap());
        }
        if (!target.methodNameSrg().equals("")) {
            Supplier<String> mappedMethod = () -> (isDevelopmentEnvironment ? TransformerManager.mapMethodName(className.replace(".", "/"), target.methodNameSrg(), target.desc()) : target.methodNameSrg()) + target.desc();
            this.srgMap.get(className).put(mappedMethod, transformer);
            ForgeTweaker.logger.info("[CSL DEBUG] REGISTERING SRG METHOD %s::%s", className, target.methodNameSrg() + target.desc());
        }
        if (!this.map.containsKey(className)) {
            this.map.put(className, new HashMap());
        }
        for (String methodName : target.methodNames()) {
            this.map.get(className).put(methodName + target.desc(), transformer);
            ForgeTweaker.logger.info("[CSL DEBUG] REGISTERING METHOD %s::%s", className, methodName + target.desc());
        }
    }

    public ClassNode transform(ClassNode classNode, String className) {
        IClassTransformer transformer = this.classMap.get(className);
        if (transformer != null) {
            try {
                classNode = transformer.transform(classNode);
                ForgeTweaker.logger.info("[CSL DEBUG] Successfully transformed class %s", className);
            }
            catch (Exception e) {
                ForgeTweaker.logger.warning("[CSL DEBUG] An error happened when transforming class %s", className);
                ForgeTweaker.logger.warning(e);
            }
        }
        return classNode;
    }

    public MethodNode transform(ClassNode classNode, MethodNode methodNode, String className, String methodName, String methodDesc) {
        String methodTarget = methodName + methodDesc;
        Map<Supplier<String>, IMethodTransformer> transSrgMap = this.srgMap.get(className);
        IMethodTransformer transformer = transSrgMap == null ? null : transSrgMap.get(transSrgMap.keySet().stream().filter(s -> ((String)s.get()).equals(methodTarget)).findFirst().orElse(null));
        Map<String, IMethodTransformer> transMap = this.map.get(className);
        if (useDeobfName && transMap != null && transformer == null) {
            transformer = transMap.get(methodTarget);
        }
        if (transformer != null) {
            try {
                methodNode = transformer.transform(classNode, methodNode);
                ForgeTweaker.logger.info("[CSL DEBUG] Successfully transformed method %s in class %s", methodName, className);
            }
            catch (Exception e) {
                ForgeTweaker.logger.warning("[CSL DEBUG] An error happened when transforming method %s in class %s", methodTarget, className);
                ForgeTweaker.logger.warning(e);
            }
        }
        return methodNode;
    }

    public static interface IMethodTransformer {
        public MethodNode transform(ClassNode var1, MethodNode var2);
    }

    public static interface IClassTransformer {
        public ClassNode transform(ClassNode var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TransformTarget {
        public String className();

        public String methodNameSrg() default "";

        public String[] methodNames() default {};

        public String desc() default "";
    }
}

